# iSentry Firefly Docker Deployment Quick Instruction
## HOW TO RUN

### Single instance

- Check all of PRE-REQUISITIES requirement to run docker container with CUDA container toolkits 
- Edit `config.txt` file for changes and follow the comments in there
    - iSentry Path
    - Set docker runtime if your are planning to run in NVIDIA GPU
    - Firefly image name
    - FIREFLY_MODEL follow the instruction in the comments, NVIDIA is default
    - Web Settings docker image name
    - HTTP/HTTPS option
    - User Login option
    - If using model optimizer, edit:
	- IV_DETECTOR to add/remove detection models. E.g "objcl fire" will tell model optimizer to generate object detection and fire detection model
	- MO_DL_MODE to add/remove detection mode. E.g "bal spd" will tell model optimizer to generate balance models and speed models
- To run model optimizer, exectute command below:

```bash
ENABLED_MODEL_OPTIMIZER=1 docker compose --env-file config.txt up
```

- To run Firefly, execute command below:

```bash
docker compose --env-file config.txt up -d
```

- To stop Firefly, run command below:

```bash
docker compose --env-file config.txt down
```

### Multiple instances

- Check [docker-compose-multi-instances.yml](./docker-compose-multi-instances.yml) file for content of multiple instance script
- Run command

```bash
docker compose --env-file config.txt -f docker-compose-multi-instances.yml up -d
```

- Stop command

```bash
docker compose --env-file config.txt -f docker-compose-multi-instances.yml down
```

- NOTE: access websettings will require extra param `?ServerID=xx`, e.g `http://192.168.0.123:8123/settings?ServerID=1`

## Tips

### Simplify docker command by rename `config.txt` to `.env`

- You can simplify docker command  FROM: 

```sh
docker compose --env-file config.txt up -d
```
 
TO

```sh
docker compose up -d
```

By rename config.txt to .env

```sh
mv config.txt .env
```